from lead.utils.data_loader import DataLoader
import numpy as np
from typing import List, Tuple, Dict

class ProblemDataLoader(DataLoader):
    def load(self) -> Dict[str, np.ndarray]:
        cities = self._read_tsp_file()
        n = len(cities)
        distances = np.zeros((n, n))
        for i in range(n):
            for j in range(n):
                if i != j:
                    distances[i,j] = self._euclidean_distance(cities[i], cities[j])
        
        return {"distances": distances}
    
    def _read_tsp_file(self) -> List[Tuple[float, float]]:
        cities = []
        with open(self.data_dir + "/ulysses16.tsp", "r") as f:
            reading_coords = False
            for line in f:
                if line.strip() == "NODE_COORD_SECTION":
                    reading_coords = True
                    continue
                if line.strip() == "EOF":
                    break
                if reading_coords:
                    parts = line.strip().split()
                    if len(parts) == 3:
                        x, y = float(parts[1]), float(parts[2])
                        cities.append((x, y))
        return cities
    
    def _euclidean_distance(self, p1: Tuple[float, float], p2: Tuple[float, float]) -> float:
        return np.sqrt((p1[0] - p2[0])**2 + (p1[1] - p2[1])**2) 