from abc import ABC, abstractmethod
from typing import Any, Dict
import os
import json

class DataLoader(ABC):
    def __init__(self, problem_path: str):
        self.problem_path = problem_path
        self.data_dir = os.path.join(problem_path, "dataset", "data")
        self.dataset = None
    
    @abstractmethod
    def load(self) -> Any:
        pass
    
    def get_data(self) -> Any:
        if self.dataset is None:
            self.dataset = self.load()
        return self.dataset 