from typing import Optional
from ..llm_integration import LLMClient
from .verify_operator import VerifyOperator

class CrossoverOperator:
    def __init__(self, llm_client: LLMClient):
        self.llm_client = llm_client
        self.verify_operator = VerifyOperator(llm_client)

    def crossover(self, code1: str, code2: str) -> str:
        prompt = f"""Please perform a crossover operation on the following two Python functions to generate a new, efficient implementation.
Funtion 1:
{code1}

Funtion 2:
{code2}

Requirements:
1. Keep the function signature unchanged.
2. Combine the advantages of both implementations.
3. Generate complete and runnable function code."""
        code = self.llm_client._call_llm(prompt, operator="crossover")
        if code:
            function_name = code1.split("def ")[1].split("(")[0].strip()
            return self.verify_operator.verify_code_format(code, function_name)
        return None