from typing import Optional
from ..llm_integration import LLMClient
from .verify_operator import VerifyOperator

class DEMutationOperator:
    def __init__(self, llm_client: LLMClient):
        self.llm_client = llm_client
        self.verify_operator = VerifyOperator(llm_client)

    def mutate(self, code: str) -> Optional[str]:
        prompt = f"""Please perform a Differential Evolution-style mutation operation on the following code:

Original Code:
{code}

Requirements:
1. Keep the function signature unchanged.
2. Introduce the idea of differential mutation to make local or global improvements to the code.
3. The mutation strength should be moderate; do not completely change the core logic of the algorithm.
4. The generated code must be a complete and runnable function.
5. Maintain the code's readability and efficiency.

Suggested Mutation Operations:
- Adjust key parameters in the algorithm.
- Modify certain conditional statements or loop structures.
- Optimize the use of data structures.
- Add or remove certain optimization steps.
- Change the implementation of certain parts of the algorithm."""

        mutated_code = self.llm_client._call_llm(prompt, operator="mutation")
        if mutated_code:
            function_name = code.split("def ")[1].split("(")[0].strip()
            return self.verify_operator.verify_code_format(mutated_code, function_name)
        return None