from typing import Dict, List
from lead.core.multi_objective.individual import MultiObjectiveIndividual

class MutationAnalysisOperator:
    
    def analyze(self, individual: MultiObjectiveIndividual,
               objective_names: List[str],
               reference_front: List[Dict[str, float]] = None) -> Dict:
        result = {
            "target_objective": None,
            "improvement_potential": {},
            "nearest_solution": None,
            "function_name": self._extract_function_name(individual.code)
        }
        
        if not individual.fitnesses:
            return result
            
        for obj in objective_names:
            if obj in individual.fitnesses:
                if reference_front:
                    best_val = min(sol[obj] for sol in reference_front)
                    result["improvement_potential"][obj] = individual.fitnesses[obj] - best_val
                else:
                    result["improvement_potential"][obj] = individual.fitnesses[obj]
        
        if result["improvement_potential"]:
            result["target_objective"] = max(
                result["improvement_potential"].items(),
                key=lambda x: x[1]
            )[0]
        else:
            result["target_objective"] = objective_names[0] if objective_names else None
        
        if reference_front:
            min_distance = float('inf')
            for sol in reference_front:
                distance = sum(
                    (individual.fitnesses[obj] - sol[obj]) ** 2
                    for obj in objective_names if obj in individual.fitnesses
                )
                if distance < min_distance:
                    min_distance = distance
                    result["nearest_solution"] = sol
        
        return result
        
    def _extract_function_name(self, code: str) -> str:
        for line in code.split('\n'):
            if line.strip().startswith('def '):
                return line.split()[1].split('(')[0]
        return "solution"  