from typing import Optional
from ..llm_integration import LLMClient

class VerifyOperator:
    def __init__(self, llm_client: LLMClient):
        self.llm_client = llm_client

    def verify_code_format(self, code: str, function_name: str) -> Optional[str]:
        """Validate if the code format meets the requirements."""
        prompt = f"""Please check if the following code meets the requirements. If not, please correct it:

{code}

Requirements:
1. Only include the function implementation code, without any descriptions, comments, or examples.
2. The main function name must be {function_name}.
3. Do not include a main function or test code.
4. Return only the corrected code, without any other content.

If the code already meets the requirements, return the original code; if it needs correction, return the corrected code."""
        
        result = self.llm_client._call_llm(prompt, operator="verify")
        return result if result else code