import os
import sys
import argparse
import json
from lead.core.evolution import EvolutionEngine
from lead.core.multi_objective.evolution import MultiObjectiveEvolutionEngine
from lead.config.settings import PROBLEMS_DIR

def parse_args():
    parser = argparse.ArgumentParser(description="Running LLM-driven algorithmic evolution")
    parser.add_argument("--problem", type=str, default="template_problem")
    parser.add_argument("--generations", type=int, default=None)
    parser.add_argument("--population", type=int, default=None)
    return parser.parse_args()

def load_engine_config(problem_path):
    config_path = os.path.join(problem_path, "problem_config.json")
    with open(config_path, "r", encoding="utf-8") as f:
        config = json.load(f)
    
    if config.get("multi_objective", False):
        return MultiObjectiveEvolutionEngine(problem_path)
    else:
        return EvolutionEngine(problem_path)

def main():
    args = parse_args()
    problem_path = os.path.join(PROBLEMS_DIR, args.problem)
    
    if not os.path.exists(problem_path):
        sys.exit(1)
    
    
    engine = load_engine_config(problem_path)
    engine.run_evolution(
        generations=args.generations,
        population_size=args.population
    )

if __name__ == "__main__":
    main()