import threading
import _thread
import time
from typing import Callable, Any, Optional

class TimeoutError(Exception):
    pass

class Timeout:
    def __init__(self, seconds: int):
        self.seconds = seconds
        self.timer: Optional[threading.Timer] = None
        self.result: Any = None
        self.exception: Optional[Exception] = None
    
    def _interrupt(self):
        _thread.interrupt_main()
    
    def run(self, func: Callable, *args, **kwargs) -> Any:
        def target():
            try:
                self.result = func(*args, **kwargs)
            except Exception as e:
                self.exception = e
        
        thread = threading.Thread(target=target)
        thread.daemon = True
        
        try:
            thread.start()
            thread.join(self.seconds)
            if thread.is_alive():
                self._interrupt()
                raise TimeoutError(f"Function execution timed out after {self.seconds} seconds")
            if self.exception:
                raise self.exception
            return self.result
        except KeyboardInterrupt:
            raise TimeoutError(f"Function execution timed out after {self.seconds} seconds") 