#!/bin/bash

GPUS=$1
NB_COMMA=`echo ${GPUS} | tr -cd , | wc -c`
NB_GPUS=$((${NB_COMMA} + 1))

NOTE="zs" # Short description of the experiment. (WARNING: logs/results with the same note will be overwritten!)

METHOD="continual-clip"

# cifar10,cifar100,tinyimagenet,imagenet-r,imagenet
# cub200,stanfordcars,flowers102,oxford_pet,eurosat,caltech101,food101,sun397,aircraft
DATASET="cifar100" 
ZS_DATASET="flowers102,oxford_pet,eurosat,caltech101,food101,imagenet-r,sun397,aircraft,cub200,stanfordcars"

N_TASKS=5

BLURRY=niid
BA=0.3
BS=0.3

BA_SIGMA=0.2
BS_ALPHA=1

N=100
M=0

RAND_NM="--rnd_NM"
# RAND_NM=""

GPU_TRANSFORM="--gpu_transform"
USE_AMP="--use_amp"


MODEL_NAME="ViT-B/16" 
EVAL_PERIOD=1000
BATCHSIZE=64

for seed in 2022 2023 2024 2025 2026
do
    INFO="${METHOD}_${NOTE}_SEED${seed}"
    CUDA_VISIBLE_DEVICES=${GPUS} python main.py --method $METHOD \
    --dataset $DATASET --zero_shot_dataset $ZS_DATASET \
    --n_tasks $N_TASKS --m $M --n $N $RAND_NM \
    --blurry_mod $BLURRY --blurry_always $BA --blurry_sudden $BS \
    --ba_sigma $BA_SIGMA --bs_alpha $BS_ALPHA \
    --rnd_seed $seed --model_name $MODEL_NAME \
    $GPU_TRANSFORM --data_dir ./data \
    --note $INFO --eval_period $EVAL_PERIOD --n_worker 4 --num_gpus ${NB_GPUS}
done
