# Code for submission "A Closer Look at NTK Alignment: Linking Phase Transitions in Deep Image Regression"

This repository contains all the necessary code to reproduce the key results presented in our paper.  The core components are:

- ```src/```:
    - ```explicit.py``` contains all source code for constructing INRs, using custom strategy for extracting NTK and its spatial gradients.
    - ```approximation.py``` contains all the code for estimating the $H$, $D$ and $a$ parameters in our Cauchy approximation.
    - ```trainer.py``` contains the training and monitoring functions used to compute the different order parameers during training.
    - ```data_utils.py``` contains all code for loading images and saving model outputs.
    - ```change_detection.py``` contains the detectors used to find the change points and confidence intervals for the order parameters.
- ```scripts/```
    - ```runner.py``` contains the code used to train the models and store experimental outputs.
    - ```extract_validation_residual_pcorr.py``` is the code for extracting the residual correlations, based on the code in ```src/image_analysis.py```

Notebooks used for exploratory analysis and figure generation are not included but can be provided upon request.  The provided scripts are sufficient to reproduce all reported results, along with the descriptions in the Supplementary Materials