# Semi-supervised Anchor-Based Federated Aggregation

## Introduction

This is the official PyTorch implementation of SemiAnAgg.

## Preparation
1. Create conda environment:
 
		conda create -n SemiAnAgg python=3.8
		conda activate SemiAnAgg

2. Install dependencies: install [pytorch](https://pytorch.org/get-started/locally/)

	     pip install -r requirements.txt	

		

## Run the code
Train model for each dataset. 



SVHN Dataset:
```
python generate_rand_embedding.py --dataset SVHN --model Res18_cifar --gpu 0 --opt sgd --base_lr 0.03 
```
```
python train.py --rounds 500 --local_ep 1 --num_labeled 1 --unsup_num=9 --dataset SVHN --model Res18_cifar --gpu 0 --opt sgd --base_lr 0.03 --loss_fn_name BSM
```


ISIC 2018 dataset:
```
kaggle datasets download -d kmader/skin-cancer-mnist-ham10000
```
```
unzip skin-cancer-mnist-ham10000 -d data/med_classify_dataset
mkdir data/ham
mv  -v data/med_classify_dataset/HAM10000_images_part_1/* data/ham
mv  -v data/med_classify_dataset/HAM10000_images_part_2/* data/ham
```

```
python generate_rand_embedding.py --dataset skin --model Res18 --gpu 0 --opt sgd --base_lr 0.03 --pre_sz=250 --input_sz=224 --datadir ./data/ham/
```
```
python train.py --rounds 500 --local_ep 1 --num_labeled 1 --unsup_num=9 --dataset skin --model Res18 --gpu 0 --opt sgd --base_lr 0.03 --loss_fn_name BSM --pre_sz=250 --input_sz=224 --datadir ./data/ham/
```




To produce all the claimed results, please modify the path of warm-up model accordingly. Warm-up models are trained on labeled clients. 

For different datasets, please modify file path, arguments "dataset" and "model" correspondingly.


## Acknoweldgement

We would like to acknoweldge RSCFed and CBAFed as we built our code on their base.
