# Information Seeking for Robust Decision Making under Partial Observability
This repository is the official implementation of [Information Seeking for Robust Decision Making under Partial Observability](). 

## Installation

Create a conda environment:

```setup
conda create -n infoseeker python=3.12
conda activate infoseeker
```

Install the dependencies:
```install
pip install -r requirements.txt
```

## Project Structure
- `envs`: the developed environment for our benchmark
- `planner`: InfoSeeker planner
- `prompt`: prompt templates
- `tasks`: task settings for our benchmark

## Run InfoSeeker
### Before Running

Fill in your Gemini API key in `gemini_key.json` under the project directory.
```api
{
    "key": ""
}
```

### Run Experiment

Run InfoSeeker on our proposed benchmark and view logs in `saved_runs` directory.
```run
python main.py
```

# Try Our Benchmark

Interact with our benchmark using user console:

```try
python human.py --task block_stacking_multiple_basic
```

### Task Options:
- `block_stacking_multiple_basic`
- `block_stacking_multiple_perturbed`
- `block_stacking_single_basic`
- `block_stacking_single_perturbed`
- `mix_color_basic`
- `mix_color_contaminated`
- `mix_color_wronglabel`
- `robot_arm_basic`
- `robot_arm_perturbed`
- `robot_navigation_basic`
- `robot_navigation_perturbed`

# API Resources
| **Gemini 2.0 Flash** | **Price per 1M Tokens** |
|---------------|-------------------------|
| Input         | $0.10 USD               |
| Output        | $0.40 USD               |

| **InfoSeeker** | **Tokens per Planning Attempt** |
|---------------|-------------------------|
| Input         | 2800              |
| Output        | 1000               |