import argparse
from envs.env_manager import EnvManager

def main():
    # Create parser 
    parser = argparse.ArgumentParser(description='Human task runner.')
    parser.add_argument('--task', type=str, required=True, help='Task type to perform')
    args = parser.parse_args()

    # Start environment
    env = EnvManager(task=args.task, task_case=1)
    domain_desc = env.start()
    print(domain_desc)
    finished = False
    steps = 0

    # Interaction loop
    while not finished:
        action = input(">")
        finished, result, steps = env.step(action)
        print(f"> {result} (step used: {steps})")

    print(f"Finished with {steps} steps.")

if __name__ == "__main__":
    main()