
#improved code ver1######################################################################3

from utils import *
from structured_actions import *
import json
import datetime


class Performer:
    def __init__(self, memory, percipient, checker):
        self.memory = memory
        self.percipient = percipient
        self.checker = checker

        self.state_info = []
        self.reward_list = []
        self.transition_list = []

    def gather_info(self, env, check_result, action, task_id, every_task_max_retries):
        obs, _, _, _ = env.step(env.action_space.no_op())
        state_now = gather_state_info(obs)
        self.state_info.append(state_now)
        self.transition_list.append(action)
        self.transition_list.append({'success': check_result})
        self.transition_list.append(state_now)

    def execute_action(self, env, action, args):
        """
        Executes the given action based on its type and arguments.
        """
        action_result = None
        if action == "find_and_reach":
            obj = update_find_obj_name(args["obj"])
            action_result = reach(env=env, target=obj)
        elif action == "change_time":
            action_result = change_time(env=env, time_tar=args["target_time"])
        elif action == "change_biome":
            action_result = change_biome(env=env, target_biome=args["target_biome"])
        elif action == "craft":
            craft_name = list(args["obj"].keys())[0].replace(" ", "_")
            craft_num = int(list(args["obj"].values())[0])
            craft_num = update_craft_num(craft_name, craft_num)
            inventory_name_list, inventory_num_list, action_result = action_craft(env, craft_name, args["platform"]=="crafting table", args["platform"]=="furnace", craft_num=craft_num)
            self.memory.update_inventory(count_inventory(inventory_name_list, inventory_num_list))
        elif action == "mine":
            obj = list(args["obj"].keys())[0].replace(" ", "_")
            if obj == 'redstone_dust' or obj == 'redstone_ore':
                obj = 'redstone'
            goal_num = int(list(args["obj"].values())[0])
            tool = "" if args["tool"] is None else args["tool"].replace("_", " ")
            y_level = args["y_level"]

            inventory_name_list, inventory_num_list, action_result = mining(env=env, object=obj, equipment=tool, goal_num=goal_num, y_level=y_level)
            self.memory.update_inventory(count_inventory(inventory_name_list, inventory_num_list))
        elif action == "fight":
            obj = list(args["obj"].keys())[0].replace(" ", "_")
            obj = update_inventory_obj_name(obj)
            goal_num = int(list(args["obj"].values())[0])
            target = args["target"]
            tool = "" if args["tool"] is None else args["tool"]
            inventory_name_list, inventory_num_list, action_result = fight(env=env, target=target, equipment=tool, target_item=obj, target_item_number=goal_num)
            self.memory.update_inventory(count_inventory(inventory_name_list, inventory_num_list))
        elif action == "equip":
            # obj = args["obj"]
            if 'obj' in args:
                obj = args["obj"]
            elif 'tool' in args:
                obj = args["tool"]
            else:
                ttd
            action_result = equip(env=env, equipment=obj)
        elif action == "apply":
            obj = list(args["obj"].keys())[0].replace(" ", "_")
            obj = update_inventory_obj_name(obj)
            goal_num = int(list(args["obj"].values())[0])
            target = update_find_obj_name(args["target"])
            tool = "" if args["tool"] is None else args["tool"]
            inventory_name_list, inventory_num_list, action_result = apply(env=env, target=target, equipment=tool, target_item=obj, target_item_number=goal_num)
            self.memory.update_inventory(count_inventory(inventory_name_list, inventory_num_list))
        elif action == "gather":
            obj = list(args["obj"].keys())[0].replace(" ", "_")
            obj = update_inventory_obj_name(obj)
            target = update_find_obj_name(obj)
            goal_num = int(list(args["obj"].values())[0])
            tool = "" if args["tool"] is None else args["tool"]
            inventory_name_list, inventory_num_list, action_result = gather(env=env, target=target, target_item=obj, target_item_number=goal_num, equipment=tool)
            self.memory.update_inventory(count_inventory(inventory_name_list, inventory_num_list))
        return action_result

    def check_and_execute_workflow(self, env, workflow_dict, task_information, task_id, every_task_max_retries):
        self.transition_list.append(task_information)
        self.state_info.append(task_information)

        # # give time to let the env initial change
        # for i in range(30):
        #     obs, _, _, _ = env.step(env.action_space.no_op())
        obs, _, _, _ = env.step(env.action_space.no_op())
        
        state_initial = gather_state_info(obs)
        self.state_info.append(state_initial)
        self.transition_list.append(state_initial)

        for action in workflow_dict['workflow']:
            name, args = action['name'], action['args']
            check_result = self.checker.check_action_preparation(name, self.memory.inventory, args)

            if not check_result["success"]:
                self.gather_info(env, check_result, action, task_id, every_task_max_retries)
                return check_result, self.transition_list

            action_result = self.execute_action(env, name, args)

            self.gather_info(env, action_result, action, task_id, every_task_max_retries)
            if not action_result["success"]:
                return action_result, self.transition_list

        # with open(f'/home/**/Workspace/MP5/MP5_agent/agent/buffer_traj/state_info_{task_id}_{every_task_max_retries}.json', 'w') as f:
        #     json.dump(self.state_info, f, cls=NumpyEncoder, indent=4)
        check_result = {
            "feedback": "",
            "success": True,
            "suggestion": ""
        }
        return check_result, self.transition_list



