"""
Convert jsonl to json
"""
import argparse

from toolemu.utils import read_jsonl, replace_file_extension, write_json

parser = argparse.ArgumentParser()
parser.add_argument("input", type=str)
args = parser.parse_args()

assert args.input.endswith(".jsonl")
data = read_jsonl(args.input)
output_file = replace_file_extension(args.input, "json")
write_json(data, output_file)
