from argparse import ArgumentParser, Namespace

from .my_typing import *


def slicing_register_args(parser: ArgumentParser):
    """Register arguments for truncation."""
    parser.add_argument(
        "--start-index", "-si", type=int, default=0, help="The start index for slicing"
    )
    parser.add_argument(
        "--trunc-num",
        "-tn",
        type=int,
        default=None,
        help="The truncation number starting from start-index",
    )


def slice_with_args(items: List[Any], args: Namespace):
    """Slice items by args."""
    items = items[args.start_index :]
    if args.trunc_num is not None:
        items = items[: args.trunc_num]
    return items


def get_slice_range(total_num: int, args: Namespace):
    """get the range of the slice."""
    end = total_num if args.trunc_num is None else args.start_index + args.trunc_num
    return args.start_index, end
