# Installation 

1. This code is based on Pytorch. The conda enviroment for running this code can be installed as follows,

```
conda env create -f environment.yml

```

2. Training code

```
# chain3
python run.py train --seed 1 --pretrain 10000 --mopt adam:5e-2,0.9 --gopt adam:5e-3,0.1 -v 500 --lsparse 0.1 --bs 256 --ldag 0.5 --predict 100 --temperature 1 -N 2 -p chain3

# fork3
python run.py train --seed 1 --pretrain 10000 --mopt adam:5e-2,0.9 --gopt adam:5e-3,0.1 -v 500 --lsparse 0.1 --bs 256 --ldag 0.5 --predict 100 --temperature 1 -N 2 -p fork3

# collider3
python run.py train --seed 1 --pretrain 10000 --mopt adam:5e-2,0.9 --gopt adam:5e-3,0.1 -v 500 --lsparse 0.1 --bs 256 --ldag 0.5 --predict 100 --temperature 1 -N 2 -p collider3

# confounder3
python run.py train --seed 1 --pretrain 10000 --mopt adam:5e-2,0.9 --gopt adam:5e-3,0.1 -v 500 --lsparse 0.1 --bs 256 --ldag 0.5 --predict 100 --temperature 1 -N 2 -p confounder3
```


`--seed` specifies the random seed

`--mopt` specifies the optimizer and learning rate used to train the functional parameters

`--gopt` specifies the optimizer and learning rate used to train the structural parameters

`--predict` specifies the number of samples used for predicting the intervened node. Specifying 0 for this argument uses the groundtruth intervention node.

`--temperature` specifies the temperature setting fot the softmax for the groundtruth structured causal model.

`-N` specifies the number of categories for the categorical distribution

`-M` specifies the number of discrete random variables

`--graph` allows one to specify via the command-line several causal DAG skeletons.

`-p` specifies, by name, one of several `--graph` presets for groundtruth causal graphs (e.g. `chain3`).

