import gdelt
import pandas as pd


date_list = []

date1 = '2019-01-01'
date2 = '2019-01-02'
mydates = pd.date_range(date1, date2).tolist()
for dt in mydates:
    m = dt.month
    d = dt.day
    if m < 10:
        m = '0' + str(m)
    if d < 10:
        d = '0' + str(d)
    query = '%s %s %s'%(dt.year, m, d)
    date_list.append(query)

gd2 = gdelt.gdelt(version=2)


for i in range(0, len(date_list), 10):
    results = gd2.Search(date_list[i:i+10],table='events',coverage=True)
    print(i, len(results))
    results.to_csv('%d.csv'%(i+731))
