import random
import torch
import numpy as np

from code_utils.config import ARGS
from model.trainer import Trainer


seed = 19940419
# seed = 1990419
# seed = 38230982
# seed = 354
# seed = 1654
random.seed(seed)
np.random.seed(seed)
torch.manual_seed(seed)
torch.cuda.manual_seed_all(seed)


if __name__ == "__main__":
    args = ARGS.read_args()

    test_setting = {
        'prefix': None,
        'epoch_nums': args.checkpoint,
    }

    trainer = Trainer(args)
    print(trainer.create_model_name(0))
    if not args.test:
        trainer.train()
    else:
        trainer.test_(test_setting)

