# script for running tests regarding the convex hull assumption

import os

DATASETS = ['mnist', 'cifar10']
DS_METHODS = ['uniform', 'twoclass']
LRS = [1e-9, 1e-8, 1e-7, 1e-6, 1e-5] # determined empirically to work well
NUM_HIDS = [1300, 6000, 12000, 21000, 32000]
NUM_SIZES = [1000, 2000, 3000, 4000, 5000]

for dataset in DATASETS:
    for ds_method in DS_METHODS:
        for lr in LRS:
            for nh, ns in zip(NUM_HIDS, NUM_SIZES):
                    exp_str = f'ds{dataset}_downsample{ds_method}_lr{lr}_datasize{ns}_hiddensize{nh}'
                    print(f'\n\nRunning Experiment: {exp_str}')
                    command = (
                            f'python train_mlp.py --check-hull --trn-size {ns} --num-hidden {nh}'
                            f' --lr {lr} --dataset {dataset} --downsample-method {ds_method}')
                    os.system(command) # will print out the result to terminal
