
set -x

LLM1LR=1e-6
LLM1KL=0
LLM2LR=1e-6
LLM2KL=5e-7
TEMP=0.5
TAG=''

ray start --head --node-ip-address 127.0.0.1 --temp-dir path_to_your_ILR/ray_tmp --num-gpus 8

ray job submit --address="http://127.0.0.1:8265" \
   --runtime-env-json='{"working_dir": "path_to_your_ILR"}' \
   -- python3 -m openrlhf.cli.train_ilr_ray \
   --ref_num_nodes 1 \
   --ref_num_gpus_per_node 8 \
   --reward_num_nodes 1 \
   --reward_num_gpus_per_node 8 \
   --actor_num_nodes 1 \
   --actor_num_gpus_per_node 8 \
   --vllm_num_engines 8 \
   --vllm_tensor_parallel_size 1 \
   --vllm_gpu_memory_utilization 0.5 \
   --colocate_actor_ref \
   --colocate_all_models \
   --vllm_enable_sleep \
   --deepspeed_enable_sleep \
   --micro_train_batch_size 2 \
   --train_batch_size 252 \
   --micro_rollout_batch_size 2 \
   --rollout_batch_size 252 \
   --n_samples_per_prompt 5 \
   --max_epochs 1 \
   --prompt_max_len 8192 \
   --max_samples 11000 \
   --generate_max_len 2048 \
   --gamma 1.0 \
   --top_p 0.95 \
   --use_kl_loss \
   --kl_estimator k2 \
   --advantage_estimator ilr \
   --zero_stage 3 \
   --bf16 \
   --input_key problem \
   --apply_chat_template \
   --normalize_reward \
   --adam_offload \
   --gradient_checkpointing \
   --load_checkpoint \
   --save_hf_ckpt \
   --save_steps 2 \
   --temperature ${TEMP} \
   --pretrain_llm1 path_of_pretrain_llm1 \
   --save_path_llm1 path_of_group2_checkpoint/temperature${TEMP}_llm1lr${LLM1LR}_llm1kl${LLM1KL}_llm2lr${LLM2LR}_llm2kl${LLM2KL}${TAG}/Meta-Llama-3.1-8B-Instruct \
   --ckpt_path_llm1 path_of_group2_checkpoint/temperature${TEMP}_llm1lr${LLM1LR}_llm1kl${LLM1KL}_llm2lr${LLM2LR}_llm2kl${LLM2KL}${TAG}/Meta-Llama-3.1-8B-Instruct \
   --use_tensorboard_llm1 path_of_group2_checkpoint/temperature${TEMP}_llm1lr${LLM1LR}_llm1kl${LLM1KL}_llm2lr${LLM2LR}_llm2kl${LLM2KL}${TAG}/tensorboard/Meta-Llama-3.1-8B-Instruct \
   --init_kl_coef_llm1 ${LLM1KL} \
   --actor_learning_rate_llm1 ${LLM1LR} \
   --pretrain_llm2 path_of_pretrain_llm2 \
   --save_path_llm2 path_of_group2_checkpoint/temperature${TEMP}_llm1lr${LLM1LR}_llm1kl${LLM1KL}_llm2lr${LLM2LR}_llm2kl${LLM2KL}${TAG}/Qwen2.5-14B-Instruct \
   --ckpt_path_llm2 path_of_group2_checkpoint/temperature${TEMP}_llm1lr${LLM1LR}_llm1kl${LLM1KL}_llm2lr${LLM2LR}_llm2kl${LLM2KL}${TAG}/Qwen2.5-14B-Instruct \
   --use_tensorboard_llm2 path_of_group2_checkpoint/temperature${TEMP}_llm1lr${LLM1LR}_llm1kl${LLM1KL}_llm2lr${LLM2LR}_llm2kl${LLM2KL}${TAG}/tensorboard/Qwen2.5-14B-Instruct \
   --init_kl_coef_llm2 ${LLM2KL} \
   --actor_learning_rate_llm2 ${LLM2LR} \
   --reward_pretrain path_of_reward_model \
   --eval_ability_file path_of_validation_file \
   --prompt_data path_of_training_file
   

ray stop
