#!/usr/bin/env bash

ID=$(basename "$0" | sed "s/.sh$//g")
ABS_PATH=$(readlink -f $0)
cd $(dirname $(dirname $(dirname ${ABS_PATH})))

MYDIR=logs/${ID}
mkdir -p ${MYDIR}
cp ${ABS_PATH} ${MYDIR}

CUDA_VISIBLE_DEVICES=0 \
python3 -u main.py \
--experiment_id ${ID} \
--parameter_random_seed 8 \
--data_name fmonth \
--algorithm fmonth \
--use_entropy_regularization_train \
--use_manifold_regularization \
--beta 0.1 \
| tee ${MYDIR}/log.txt