from .agents import DeepResearchAgent,ReviewAgent
import asyncio
import json

if __name__ == '__main__':
    topic = input("Please provide a research topic:")
    publicationData=":2022-12-01"
    review_agent = ReviewAgent()
    deep_research_agent = DeepResearchAgent()

    print(f"begin to generate idea and experiment of topic {topic}")
    idea,related_experiments,entities,idea_chain,ideas,trend,future,human,year=  asyncio.run(deep_research_agent.generate_idea_with_chain(topic))
    experiment = asyncio.run(deep_research_agent.generate_experiment(idea,related_experiments,entities))
    experiment = asyncio.run(deep_research_agent.improve_experiment(review_agent,idea,experiment,entities))
    print(f"succeed to generate idea and experiment of topic {topic}")
    res = {"idea":idea,"experiment":experiment,"related_experiments":related_experiments,"entities":entities,"idea_chain":idea_chain,"ideas":ideas,"trend":trend,"future":future,"year":year,"human":human}
    with open("result.json","w") as f:
        json.dump(res,f)