import aiohttp
import asyncio

class Result:
    def __init__(self,title,abstract,pdf_link) -> None:
        self.title = title
        self.abstract = abstract
        self.pdf_link = pdf_link


def class_to_dict(obj):
    if not hasattr(obj, "__dict__") and not isinstance(obj, dict) and not isinstance(obj, list):
        return obj
    
    result = {}
    if isinstance(obj, list):
        return [class_to_dict(item) for item in obj]
    elif isinstance(obj, dict):
        return {k: class_to_dict(v) for k, v in obj.items()}
    else:
        for key, value in obj.__dict__.items():
            if isinstance(value, list):
                result[key] = [class_to_dict(item) for item in value]
            elif isinstance(value, dict):
                result[key] = {k: class_to_dict(v) for k, v in value.items()}
            else:
                result[key] = class_to_dict(value)
    return result

async def fetch(url):
    async with aiohttp.ClientSession() as session:
        async with session.get(url) as response:
            if response.status == 200:
                content = await response.read()  
                return content
            else:
                response.raise_for_status() 