"""
This module implements a base class for solvers.
"""

import abc

import problem
import plan
from setting import Rational


class Solver(abc.ABC):
    """A base class for solvers."""

    @abc.abstractmethod
    def solve(self, data: problem.PatrollingProblem, lb: Rational = None, ub: Rational = None) -> plan.DefensePlan:
        """Solves a patrolling problem."""
