clearvars;
close all;

num_runs = 10;
num_proposals = [1, 2, 3, 4, 5, 6, 7, 8];
L_max = [1, 2, 3, 4, 5, 6, 7, 8];
MSE_ours = zeros(num_runs, length(num_proposals), length(L_max));
MSE_baseline = zeros(num_runs, length(num_proposals), length(L_max));
VarW_ours = zeros(num_runs, length(num_proposals), length(L_max));
VarW_baseline = zeros(num_runs, length(num_proposals), length(L_max));

for run = 1:num_runs
    S_ours = readlines(sprintf('ours/ours_%02d.out', run));
    S_baseline = readlines(sprintf('baseline/baseline_%02d.out', run));
    [M, W] = get_matrix(S_ours, length(num_proposals), length(L_max));
    MSE_ours(run, :, :) = M;
    VarW_ours(run, :, :) = W;
    [M, W] = get_matrix(S_baseline, length(num_proposals), length(L_max));
    MSE_baseline(run, :, :) = M;
    VarW_baseline(run, :, :) = W;
end

MSE_ours_std = squeeze(std(MSE_ours, 0, 1)) / sqrt(num_runs);
MSE_ours = squeeze(mean(MSE_ours, 1));
MSE_baseline_std = squeeze(std(MSE_baseline, 0, 1)) / sqrt(num_runs);
MSE_baseline = squeeze(mean(MSE_baseline, 1));
VarW_ours = squeeze(mode(VarW_ours, 1));
VarW_baseline = squeeze(mode(VarW_baseline, 1));

function [M, W] = get_matrix(S, sz1, sz2)
    M = zeros(sz1, sz2);
    W = zeros(sz1, sz2);
    row_idx = 0;
    col_idx = 1;

    for i = 1:length(S)
        if startsWith(S(i), 'Testing with')
            row_idx = row_idx + 1;
            col_idx = 0;
        end
        if startsWith(S(i), 'log(Lmax)')
            col_idx = col_idx + 1;
            A = sscanf(S(i), 'log(Lmax)=%d  var_w_a=%f  MSE=%e', 3);
            W(row_idx, col_idx) = A(2);
            M(row_idx, col_idx) = A(3);
        end
    end
end