function [A,DataStr] = GetDataSetSparseRecovery(iwhich)
rand('seed',0); randn('seed',0);


switch iwhich
    case 11 % nonsparse
        A = RandomSampling(512,1024); DataStr = sprintf('randn-%d-%d',512,1024);
    case 12
        A = RandomSampling(512,2048); DataStr = sprintf('randn-%d-%d',512,2048);

    case 21 % nonsparse
        A = GetDCT(512,1024); DataStr = sprintf('randn-%d-%d',617,1024);
    case 22
        A = GetDCT(512,2048); DataStr = sprintf('randn-%d-%d',617,2048);

    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  
    case 31 % nonsparse
        load mnist;
        m = 1024;
        A = RandomSelCol(x',m)'; A = CenterData(A);
        A = A';
    case 32
        load mnist;
        m = 2048;
        A = RandomSelCol(x',m)'; A = CenterData(A);
        A = A';

   case 41 % nonsparse
%         load cnn_4096d_Caltech_256;
%         m = 512;
%         n = 1024;
%         A = RandomSelCol(feat,m); 
%         A = RandomSelCol(A',n)'; 
%         A = CenterData(A);
%         A = A';
        load TDT2;
        m = 512;
        n = 1024;
        A = RandomSelCol(fea,m); 
        A = RandomSelCol(A',n)'; 
        A = CenterData(A);
        A = A';
    case 42
%         load cnn_4096d_Caltech_256;
%         m = 512;
%         n = 2048;
%         A = RandomSelCol(feat,m); 
%         A = RandomSelCol(A',n)'; 
%         A = CenterData(A);
%         A = A';
        load TDT2;
        m = 512;
        n = 2048;
        A = RandomSelCol(fea,m); 
        A = RandomSelCol(A',n)'; 
        A = CenterData(A);
        A = A';
        
end
A =  A / norm(A,'fro');

function A = GetIsolet(n)
load isolet;
A = x'; A = double(A);
A = RandomSelCol(A,n);

function A = RandomSampling(M, N)
    A = randn(M, N);  % Generate random values from a Gaussian distribution

    % Normalize the rows of A to have unit norm
    for i = 1:M
        A(i, :) = A(i, :) / norm(A(i, :));
    end
    
function A = GetDCT(M, N)
DCT_matrix = dctmtx(N);
A = DCT_matrix(1:M, :);  % Extract the first M rows


function A = Wavelet(M, N)
wavelet_name = 'db1';  % Choose a wavelet family
[cA, cD] = dwt(eye(N), wavelet_name);
Wavelet_matrix = [cA; cD];
A = Wavelet_matrix(1:M, :);  % Extract the first M rows
size(A)
ddd

function A = FFT(M, N)
FFT_matrix = ifft(eye(N));
A = FFT_matrix(1:M, :);  % Extract the first M rows
