function test_QR
rand('seed',110);
randn('seed',110);
val_max = -inf;
val_min = inf;

for iter = 1:1000000000000000000
    
    n = 11;
    x1 = randn(n,1)*0.10;
    x2 = randn(n,1)*0.10;
    z1 = randn(n,1)*0.10;
    z2 = randn(n,1)*0.10;
    lambda = rand(1);
    
    omega = rand(1);
    mu = rand(1) / omega;
    x = lambda*x1 + (1-lambda)*x2;
    z = lambda*z1 + (1-lambda)*z2;
    up = lambda*(1-lambda)*omega*norm(z1-z2)^2 + 1/mu*norm(x-z)^2 - 1/mu*lambda*norm(x1-z1)^2  - 1/mu*(1-lambda)*norm(x2-z2)^2;
    down = 1/(1-omega*mu)*lambda*(1-lambda)*norm(x1-x2)^2;
    val =  up / down ;
    
    val_min = min(val_min,val);
    val_max = max(val_max,val);
    
    fprintf('iter:%d, min:%f, max:%f \n',iter,val_min,val_max   );
    
end

