function [theta1,alpha1,sigma,theta2,alpha2,xi] = FindSuitableParametersCaseA(A)
% A can be a general matrix with AA' is positive definite

eps1 = 0.01; eps2 = 1; eps3 = 0.001;
vvv = eig(A*A');

% Choose parameters the the n-1 block
eps0 = 1e-12;
% theta - 1 - (2+eps1) alpha theta > eps0
% theta - 1 - eps0  > (2+eps1) alpha theta
choose_alpha1 = @(theta)(theta-1-eps0) / ((2+eps1)*(theta));
theta1 = 1.05;
alpha1 = choose_alpha1(theta1);

choose_alpha2 = @(theta)(theta-1)/((2+eps1)*(1+theta)) * (1-eps1);

% adjust parameters for the last block
theta2 = 1.5;
alpha2 = choose_alpha2(theta2);

gamma = 0.999*( theta2 - 1 - (2+eps1)*alpha2*theta2 );
gamma_n_primal = gamma*(1-eps3);

delta = 1 + eps2;
tau = (1+eps1)*alpha2^2;
chi = (1+eps3)*theta2;
kappa = min(vvv)/max(vvv);
sigma_ratio = gamma_n_primal / ( 8*delta*(chi^2 + chi*tau) );

sigma = kappa*sigma_ratio;

xi = min(eps1,eps2*sigma);
Cu = 4*delta*sigma 
dd
