function test_orth
clc;clear all;close all;
rand('seed',0);
randn('seed',0);
% while 1
n = 112;
C = randn(n);
C = C*C';
HandleObj = @(X) ComputeObj(X,C);
r = 11;
X = randn(n,r);
X = myQR2(X);
L = norm(C);
max_iter = 500;
[X1,his1] = OptStiefelGBB(X,HandleObj ,max_iter);


% [X2,his2] = nesterov111O(X,HandleObj);
[X2,his2] = NesterovInverse(X,HandleObj,L,max_iter);
% [X2,his2] = NesterovNew1819(X, HandleObj,L,max_iter);
% [X2,his2] = simple(X,HandleObj ,L,max_iter);
% [X3,his3] = nesterov(X,HandleObj ,L,1);

%
%  while 1
% [X4,his4] = nesterov_heavy_linesearch(X,HandleObj ,mu,L,max_iter,C);
%  end

semilogy([1:length(his1)],his1,'c','LineWidth',3);hold on;
semilogy([1:length(his2)],his2,'r','LineWidth',3);hold on;
% semilogy([1:length(his3)],his3,'b','LineWidth',3);hold on;
% semilogy([1:length(his4)],his4,'y','LineWidth',3);hold on;

min(his1)-min(his2)
% HandleObj(X2)
% HandleObj(X3)
legend('wen','CG')
% legend('wen','simple','new','wen2');

function [X,his] = NesterovNew1819(X, fun,L,max_iter)


XP = X;
his = [];
for iter = 1 : max_iter
    
    Xc = X + 0.1*(X-XP);
    [~,Gc] = fun(Xc);
    [fobj_old] = fun(X);
    alpha = 100;
    for in = 1:10000000
        G = X - (Xc - alpha*Gc);
        rG = G - X*G'*X;
        D= -rG;
        XP = X;
        X_plus = retr(X,alpha*D);
        f_next =  fun(X_plus);
        if(f_next<fobj_old - 1*alpha*norm(G,'fro')^2),break;end
        alpha = alpha/2;
    end
    X = X_plus;
    his(iter) = f_next;
    fprintf('iter:%d, fobj:%f\n',iter,f_next);
end
plot(his)

function [X,his]= nesterov_heavy_linesearch1(X, fun ,mu,L,max_iter,C)

his = [];
alpha =0.999;
Y = X;
for iter = 1:max_iter
    [FX,G] = fun(X);
    D = - G + X*G'*X;
    YP = Y;
    
    V = 0.01;
    for in = 1:10
        Y = X + V*D;
        Delta = V*D + alpha*(Y-YP);
        
        if( mdot(Delta,G)  <= -0.5*V*mdot(Delta,Delta))
            Delta = V*D + alpha*(Y-YP);
        else
            Delta = V*D ;
            fprintf('*');
        end
        [X_plus] = retr(X,Delta);
        f_next = fun(X_plus);
        if(f_next - FX <= - 0.01*V*mdot(Delta,Delta))
            break;
        end
        V = V/2;
    end
    
    in
    X = X_plus;
    his(iter) = f_next;
    fprintf('iter:%d, fobj:%f \n',iter,f_next);
end
X = X_plus;
% plot(his)

function [X,his]= nesterov_heavy_linesearch(X, fun ,mu,L,max_iter,C)

XP = X;
his = [];
alpha =0.9;
max_val = -inf;
min_val = inf;
Y = X;
for iter = 1:max_iter
    [FX,G] = fun(X);
    D = - G + X*G'*X;
    YP = Y;
    V = 1/L;
    Y = X + V*D;
    Delta = V*D + alpha*(Y-YP);
    if( mdot(Delta,G)  <= -0.5*V*mdot(Delta,Delta))
        [X_plus] = retr(Y+alpha*(Y-YP),V*0);
    else
        [X_plus] = retr(Y,V*0);
        fprintf('*');
    end
    f_next = fun(X_plus);
    X = X_plus;
    his(iter) = f_next;
    fprintf('iter:%d, fobj:%f \n',iter,f_next);
end
X = X_plus;
% plot(his)


function [X,his]= Nesterov(X, fun ,L,max_iter)
X = oproj(X);
his = [];
[FX,G] = fun(X);
beta =  0.6;
XP  = X;
for iter = 1:max_iter
    
    Xc = X + beta*(X-XP);
    [FXc,Gc] = fun(Xc);
    alpha = 1;
    rGc = RieG(Gc,Xc);
    for i = 0:20
        D = Xc*Gc'*Xc - Gc;
        X_plus = retr(Xc,-rGc);
        if( fun(X_plus) - FXc <= - 0.01 * alpha*norm(rGc,'fro')^2),
            break;
        end
        alpha = alpha/2;
    end
    XP = X;
    X = X_plus;
    
    his(iter) = FX;
    fprintf('iter:%d, fobj:%f \n',iter,FX);
end

function [X,his]= CG(X, fun ,L,max_iter)
X = oproj(X);
his = [];
[FX,G] = fun(X);
Eta = - RieG(G,X);
for iter = 1:max_iter
    XP = X;
    alpha =  0.1;
    for in = 1:1000
        X_plus = retr(X,alpha*Eta);
        if( fun(X_plus) - FX <= - 0.01 * alpha*norm(Eta,'fro')^2),
            break;
        end
        alpha = alpha/10;
    end

    X = X_plus;
    GP = G;
    [FX,G] = fun(X);
    if(iter==1)
        beta = 0;
    else
        beta = (norm(RieG(G,X),'fro')^2) / (norm(RieG(GP,XP),'fro')^2);

%          beta =  mdot( RieG(G,X), RieG(G,X) - RieG(GP,XP) )  / mdot( RieG(GP,XP),RieG(GP,XP))  ;

    end
    
    Eta = - RieG(G,X) + beta*Transport(alpha*Eta,Eta,XP);
    
    if(mdot(Eta,RieG(G,X))>0)
        Eta = - RieG(G,X);
    end
    
    his(iter) = FX;
    fprintf('iter:%d, fobj:%f \n',iter,FX);
end

% plot(his)
function [X,his]= NesterovInverse(X, fun ,L,max_iter)
X = oproj(X);
his = [];
[FX,G] = fun(X);
beta = 0.4;
XP  = X;
t = 0.5;
for iter = 1:max_iter
 
%     t0 = t;
%     t = (1 + sqrt(1+4*t*t)) / 2;
    beta =  0.2;
   
    Xc = RetractionCT(X,beta*InverseRetractionCT(X,XP));

    [FXc,Gc] = fun(Xc);
    alpha = 0.10;
    rGc = RieG(Gc,Xc);
        
    for i = 0:100000
        X_plus = RetractionCT(Xc,-alpha*rGc);
        FX = fun(X_plus);
        if( fun(X_plus) - FXc <= - 0.01 * alpha*norm(rGc,'fro')^2),
            break;
        end
        alpha = alpha/10;
    end
    XP = X;
    X = X_plus;
    
    his(iter) = FXc;
    fprintf('iter:%d, fobj:%f \n',iter,FX);
end
 

function [f,g ]  =ComputeObj(X,C)
g = C*X;
f = mdot(X,g)/2;

function R = InverseRetractionCT(X,Y)
[n,r] = size(X);
I = eye(r);
R = 2*Y*inv(I + X'*Y) + 2*X*inv(I +Y'*X) - 2*X;

function R = RetractionCT(X,Xi)
[n,r] = size(X);
I = eye(n);
PX = I - 0.5*X*X';
O = 0.5*(PX*Xi*X' - X*Xi'*PX);
R = inv(I - O)*(I + O)*X;

function [X,his,itr,NumEvaFun]= simple(X, fun ,L,max_iter)

XP = X;
his = [];
for iter = 1 : max_iter
    [fobj,G] = fun(X);
    
    D =  - (G - X*G'*X);
    
    %     X = retr(X,1/L*D);
    %     gamma = 0.5;
    alpha = 0.01;
    for i=0:100
        X_plus = retr(X,alpha*D);
        if(fun(X_plus) - fobj <= - 0.5 * alpha*norm(D,'fro')^2),
            break;
        end
        alpha = alpha/2;
    end
    XP = X;
    X = X_plus;
    
    his(iter) = fobj;
    fprintf('iter:%d, fobj:%f\n',iter,fobj);
end
function [X,his,itr,NumEvaFun]= nesterov(X, fun ,L,flag)

XP = X;
his = [];
for iter = 1 : 200
    [fobj,G] = fun(X);
    grad_c =  G - X*G'*X;
    D = -grad_c ;
    D2 = X-XP;
    dtX =  G - X*G'*X;
    if(iter==1)
        tau = 0.01;
    else
        S = X - XP;
        Y = dtX - dtXP;
        SY = abs(iprod(S,Y));
        if mod(iter,2)==0; tau = (norm(S,'fro')^2)/SY;
        else tau  = SY/(norm(Y,'fro')^2); end
        tau = max(min(tau,1e20), 1e-20);
    end
    
    for i = 0:1000000
        if(flag==1)
            beta = 0.9;
        else
            beta = 1;
        end
        X_plus = retr(X, tau*(beta*D - (1-beta)*sign(mdot(D2,G))*D2));
        f_next = fun(X_plus);
        if( f_next - fobj <= - 1e-5*tau*norm(D,'fro')^2),break;end
        tau = tau/2;
    end
    
    dtXP = dtX;
    XP = X;
    X = X_plus;
    his(iter) = f_next;
    
    fprintf('iter:%d, fobj:%f\n',iter,fobj);
end
X = X_plus;





function [X,his]= nesterov_heavy111(X, fun ,L)

XP = X;
his = [];
alpha = 0.99;
fobj = fun(X);

for iter = 1:200
    Xc = X + alpha*(X-XP);
    [fobj,Gc] = fun(Xc);
    Dc = - Gc + Xc*Gc'*Xc;
    
    alpha = 2/L;
    X_plus = retr(X,alpha*Dc);
    if( fun(X_plus) > fun(X) + 1e-8)
        df
    end
    XP = X;
    X = X_plus;
    his(iter) =  fun(X);
    fprintf('iter:%d, fobj:%f \n',iter,fobj);
end
X = X_plus;




function [X,his,itr,NumEvaFun]= nesterov_bak(X, fun ,L)
rhols = 0.01;
XP = X;
his = [];
for iter = 1 : 200
    
    Xc = X + 0.9*(X-XP);
    [fobj,G] = fun(X);
    [fobj_c,G_c] = fun(Xc);
    if(fobj_c - fobj > 0 )
        G_c = G;
        Xc = X;
        fobj_c = fobj;
        fprintf('1');
    else
        fprintf('2');
    end
    
    grad_c =  G_c - Xc*G_c'*Xc;
    rD = -grad_c;
    
    
    
    alpha = 0.5;
    for i = 0:10000000000
        X_plus = retr(Xc,alpha*rD);
        f_next = fun(X_plus);
        if( f_next - fobj_c <= - 0.5 * alpha*norm(rD,'fro')^2),break;end
        alpha = alpha/2;
    end
    
    
    XP = X;
    X = X_plus;
    his(iter) = f_next;
    fprintf('iter:%d, fobj:%f\n',iter,fobj);
end
X = X_plus;

function X = ProjTXM(G,X)
% min_{X} 0.5 ||X-G||_F^2
% X \in T_X(M)
X = G - X* (G'*X+X'*G)/2;

function [Q,R] = retr(X,Xi)
% R = polar(X+Xi);
[Q,R] = myQR2(X+Xi);
function [Q,R] = myQR2(X)
[Q, R] = qr(X,0);


function [X,his]= OptStiefelGBB(X, fun,max_iter)

his = [];
rhols = 1e-5;

[F, G] = fun(X);


for itr = 1 : max_iter
    
    dtX = G - X*G'*X;
    nrmG  = norm(dtX, 'fro');
    if(itr==1)
        tau = 0.01;
    else
        S = X - XP;
        Y = dtX - dtXP;
        SY = abs(iprod(S,Y));
        if mod(itr,2)==0; tau = (norm(S,'fro')^2)/SY;
        else tau  = SY/(norm(Y,'fro')^2); end
        tau = max(min(tau,1e20), 1e-20);
    end
    XP = X; FP = F;  dtXP = dtX;
    for in = 1:100
        [X] = myQR2(XP - tau*dtX);
        [F,G] = fun(X);
        if F <= FP - tau*rhols*nrmG^2;
            break;
        end
        tau = tau/2;
    end
    his = [his;F];
    
    
    fprintf('%4d  %3.2e\n',  itr, F);
end






function a = iprod(x,y)
%a = real(sum(sum(x.*y)));
a = real(sum(sum(conj(x).*y)));




function [Q, RR] = myQR(XX,k)
[Q, RR] = qr(XX, 0);
diagRR = sign(diag(RR)); ndr = diagRR < 0;
if nnz(ndr) > 0
    Q = Q*spdiags(diagRR,0,k,k);
    %Q(:,ndr) = Q(:,ndr)*(-1);
end


function [r] = mdot(x,y)
r = sum(sum(x.*y));


