function [R,nuclear_norm_X] = OrthProj(X)
% min_{R} 0.5 ||R-X||_F^2,
% s.t. R'R = I_d, when n > d
%      RR' = I_n, when n <= d
% X: n x d
%

[n,d] = size(X);
if(n>=d)
    [P, S, Q] = svd(X,0);
    R = P*Q';
    nuclear_norm_X = sum(diag(S));
else
    error('n>=d');
    [P, S, Q] = svd(X',0);
    R = P*Q';
    R = R';
    nuclear_norm_X = sum(diag(S));
end