function [x] = nonconvex_prox_l1(c,alpha,lambda)
% min_x 0.5 alpha || x - c ||_2^2 - lambda ||x||_1
% c can be a matrix
c_mat = c;
c = c(:);
handle_f = @(x) 0.5*alpha.*(x-c).^2 - lambda*abs(x);
n = length(c);
x1 = zeros(n,1);
x2 = c + lambda/alpha;
x3 = c - lambda/alpha;
x = ComputeBestRoot3(handle_f,x1,x2,x3);
x = reshape(x,size(c_mat));

% slow version
% n = length(c);
% x = zeros(n,1);
% for i=1:n,
%     x(i) = nonconvex_prox_l1_one(c(i),alpha,lambda);
% end


 

function [x] = nonconvex_prox_l1_one(c,alpha,lambda)
% min_x 0.5 alpha || x - c ||_2^2 - lambda ||x||_1
x1 = 0;
x2 = (lambda + alpha*c)/alpha;
x3 = (-lambda + alpha*c)/alpha;
f = @(x) 0.5*alpha*(x-c)^2 - lambda*norm(x,1);
f1 = f(x1);
f2 = f(x2);
f3 = f(x3);

xs = [x1;x2;x3];
fs = [f1;f2;f3];
[~,ind]=min(fs);
x = xs(ind);