from add_sys import *
from multiple_experiment_launcher import multiple_experiment
from iterator_exp import ExperimentIterator
from utils_experiment import create_name


if __name__ == '__main__' :
    args = get_default()
    args = get_default_local(args)
                                     
    args.args_trainer.monte_carlo_gradient_estimator = "REBAR"
    args.args_distribution_module.distribution_module = "REBARBernoulli"
    args.args_distribution_module.distribution = "Bernoulli"
    args.args_distribution_module.distribution_relaxed = "RelaxedBernoulli"


    origin_path = args.args_output.path
    args.args_trainer.complete_trainer = "SEPARATE_LOSS"
    args.args_interpretable_module.interpretable_module = "DECOUPLED_SELECTION"
    args.args_classification.imputation = "ConstantImputation"


    iterator = ExperimentIterator(iter_cste= True, iter_lambda=True, iter_rate=False)
    count = 0

    for index, dataset_name, dataset, loader in iterator.__iter__(args) :
        args_local = create_name(args, dataset_name, name_experiment, count)
        
        count = multiple_experiment(
                    count,
                    dataset,
                    loader,
                    complete_args=args_local,
                    name_modification = True)
