from add_sys import *
from multiple_experiment_launcher import multiple_experiment
from iterator_exp import ExperimentIterator
from utils_experiment import MixtureOfLogisticsIterator, create_name


if __name__ == '__main__' :
    args = get_default()
    args = get_default_local(args)
    
    args.args_trainer.monte_carlo_gradient_estimator = "PATHWISE"
    args.args_distribution_module.distribution_module = "DistributionWithTemperatureParameter"
    args.args_distribution_module.distribution = "RelaxedSubsetSampling_STE"
    args.args_selection.regularization = None
    args.args_selection.loss_regularization = None # L1, L2 

    
    origin_path = args.args_output.path
    args.args_trainer.complete_trainer = "SINGLE_LOSS"
    args.args_interpretable_module.interpretable_module = "COUPLED_SELECTION"
    args.args_classification.imputation = "ModuleImputation"
    
    logistics_iterator = MixtureOfLogisticsIterator(transform_mean = 0.0, transform_std = 255., mean_imputation=False, )


    iterator = ExperimentIterator(iter_cste= False, iter_lambda=False, iter_rate=True, add_noise=False)
    count = 0
    for index, dataset_name, dataset, loader in iterator.__iter__(args) :
        for path_for_weights in logistics_iterator.__iter__(args, loader, dataset_name) :
            args_local = create_name(args, dataset_name, name_experiment, count)

    
            count = multiple_experiment(
                        count,
                        dataset,
                        loader,
                        complete_args=args_local,
                        name_modification = True)
