from .SupervizedLearningWithMissingData import *
from .classification_network import *
from .dataset_based_classifier import *
from .autoencoder_wrapper import *


classifiers_list = {
    "none": None,
    "ConvClassifier2" : ConvClassifier2,
    "RealXClassifier" : RealXClassifier,
    "DatasetBasedClassifier" : DatasetBasedClassifier,
    "AutoEncoderWrapper": AutoEncoderWrapper,
    "ResNet50": ResNet50,
    "ResNet34": ResNet34,
}

def get_pred_network(classifier_name):
    if classifier_name == "none" or classifier_name == None:
        return None
    elif classifier_name in classifiers_list:
        return classifiers_list[classifier_name]
    else:
        raise ValueError(f"Classifier {classifier_name} not found")
