# FlowRefiner

## Files and Folders

- `FlowRefiner_train.py`: Main training script
- `data_process.py`: Process traffic pcap files and make dataset with label noise
- `engine.py`: Key steps of FlowRefiner
- `model.py`: Model architecture
- `util/`: Utility functions
- `data/`: Folder for datasets
- `output_dir/`: Pre-trained checkpoint

## Setup

Dependencies:
- Python ≥ 3.8
- PyTorch ≥ 1.10
- torchvision
- timm==0.3.2
- scikit-learn
- matplotlib


## Dataset

Noisy dataset example (ISCXVPN with 20% label noise):

```
Path: ./data/ISCXVPN_noisy20
```

To generate a dataset with a specified label noise ratio:

```
Code: data_process.py
Function: make_noise_dataset(raw_dataset_path, noise_ratio)
```

## Run
```
python FlowRefiner_train.py 
```

