# Uncovering Locally-Persistent Bias via Ceteris Paribus Fairness

This repository provides tools for verifying **Persistent-Bias-Aware (PBA) Fairness** of neural network classifiers under input perturbations and sensitive attribute flips.

---

## 📂 Project Structure

- `main.py` — Entry point script for running verification experiments.  
- `config.py` — Stores configuration values (dataset, deltas, flags, and model paths).  
- `help_funcs.py` — Helper functions for loading data, networks, attribute flipping, and utilities.  
- `outputs/` — Directory where experiment results (`.xlsx`) are stored.  

---

## ⚙️ Requirements

- Python 3.8+  
- TensorFlow  
- NumPy, Pandas  
- [Gurobi Optimizer](https://www.gurobi.com/) with valid license  
- pytictoc

---

## 🚀 Running Experiments

Experiments are launched using `main.py`.

All parameters (model path, deltas, sensitive attributes, flipping flags, etc.) are configured inside `config.py`.

To try different datasets or models, simply update the values in `config.py` before running.

---

## 📊 Outputs

Results are saved in `outputs/` as Excel files (`.xlsx`).

Each file contains:
- `Number` : Sample index  
- `Outcome` : Predicted label  
- `Status` : Verification status (1 = verified, 0 = not verified)  
- `Distance` : Minimum margin  
- `Sensitive Attribute` : Value of sensitive attribute (gender/race/age)  
- `Time` : Processing time per sample  

