# Communicative Watch-And-Help (CWAH)

## Setup

### Step 1: Install the VirtualHome Simulator and API
Clone the modified VirtualHome API (wah branch) and download the provided simulator executable.

```bash
# Clone the VirtualHome API (wah branch)
git clone --branch wah https://github.com/xavierpuigf/virtualhome.git

# Download simulator (Linux x86-64)
gdown https://drive.google.com/uc?id=1L79SxE07Jt-8-_uCvNnkwz5Kf6AjtaGp
unzip executable.zip
chmod +x executable/linux_exec.v2.3.0.x86_64
```

Your project structure should look like this:

```
|-- cwah/
|-- virtualhome/
|-- executable/
```

---

### Step 2: Install Dependencies
Create a conda environment and install requirements.

```bash
cd cwah
conda create --name cwah python=3.9
conda activate cwah
pip install -r requirements.txt
```

---

## Run Experiments
Example scripts are provided under the `scripts/` folder.  

For instance, to run experiments with **two LLM Agents**:

```bash
sh scripts/gpt-4o-mini_w-comm.sh
```
