lm_id=gpt-4o-mini
cot=true
communication=true

if [ "$cot" = "none" ]; then
  max_tokens=256
elif [ "$cot" = "low" ]; then
  max_tokens=1024
elif [ "$cot" = "medium" ]; then
  max_tokens=4096
elif [ "$cot" = "high" ]; then
  max_tokens=16384
elif [ "$cot" = "true" ]; then
  max_tokens=1024
else
  echo "Invalid cot value: $cot"
  exit 1
fi

if [ "$communication" = "true" ]; then
  communication_flag="--communication"
  comm_mode="communication"
else
  communication_flag=""
  comm_mode="no_communication"
fi

kill -9 $(lsof -t -i :6314)

python testing_agents/test_symbolic_LLMs.py \
--prompt_template_path LLM/prompt_com.csv \
--executable_file ../executable/linux_exec.v2.3.0.x86_64 \
--base-port 6314 \
--lm_id $lm_id \
--mode LMs-$lm_id-$cot-$comm_mode \
--source openai \
--t 0.7 \
--max_tokens $max_tokens \
--num_runs 5 \
--num-per-task 2 \
--cot $cot \
$communication_flag \
--debug
