# TDW Multi-Agent Transport (TDW-MAT)

## Codebase Layout

```
|__ tdw-gym/                       main code
|       |__ challenge.py            main evaluation code
|       |__ tdw_gym.py              main environment code
|       |__ lm_agent.py             Ours
|
|__ scene_generator/                dataset generation code
|
|__ dataset/                        dataset configuration & storage
|
|__ transport_challenge_multi_agent/  low-level environment controller
|
|__ scripts/                        experiment scripts
|
|__ Ours_LLM                        OUrs
```

---

## Setup

Run the following commands step by step to set up the default environment:

```bash
cd tdw_mat
conda create -n tdw_mat python=3.9
conda activate tdw_mat
pip install -r requirements.txt
```

---

## Run Experiments

Example scripts are provided under `scripts/` and `scripts/wo_gt_mask/`.  

For instance, to run experiments with **two LLM Agents**:

```bash
sh ./scripts/test_LMs.sh
```

Other scripts are available for HP baseline and Cooperative LLM Agent experiments in the same folders.  
