# Cascaded Leanred Bloom Filter (CLBF)

## Obtain the Source Code
```bash
git clone --recursive THE_URL_OF_THIS_REPO
```

## Docker Build and Run
```bash
./docker_build.sh
./docker_run.sh
```

## Download and Preprocess Dataset
```bash
# Malicious URLs dataset
./scripts/download_dataset/url_download.sh
./scripts/preprocess/url_preprocess.sh

# Ember dataset
./scripts/download_dataset/ember_download.sh
./scripts/preprocess/ember_preprocess.sh
```

## Experiment examples
### Train and Test CLBF
```bash
# Train XGBoost model
./scripts/xgboost/train_xgboost.sh

# Construct CLBF using the trained XGBoost model
./scripts/clbf/construct_clbf.sh

# Test CLBF
./scripts/clbf/test_clbf.sh
```
### Train and Test the Bloom Filter and the other Learned Bloom Filters
```bash
# Train and test Bloom Filter
./scripts/bloom/train_bloom.sh
./scripts/bloom/test_bloom.sh

# Train and test Partitioned Learned Bloom Filter
./scripts/xgboost/train_xgboost.sh
./scripts/plbf/train_plbf.sh
./scripts/plbf/test_plbf.sh

# Train and test Sandwitched Learned Bloom Filter
./scripts/xgboost/train_xgboost.sh
./scripts/sandwichedlbf/construct_sandwichedlbf.sh
./scripts/sandwichedlbf/test_sandwichedlbf.sh
```
### Visualize the results
```bash
./scripts/plot/plot.sh
```
