#!/bin/bash

set -euo pipefail

IMAGE_NAME="cascaded-lbf"
IMAGE_TAG="latest"

DATA_DIR="$(pwd)/data"
EXPERIMENT_DIR="$(pwd)/experiment"
FIG_DIR="$(pwd)/fig"
MODELS_DIR="$(pwd)/models"
PLOT_DIR="$(pwd)/plot"
RESULTS_DIR="$(pwd)/results"
SRC_DIR="$(pwd)/src"
SCRIPTS_DIR="$(pwd)/scripts"
THIRDPARTY_DIR="$(pwd)/thirdparty"
TEST_OUTPUTS_DIR="$(pwd)/test_outputs"

docker run -it --rm \
    --cpus="1" \
    -v $DATA_DIR:/workspace/data \
    -v $EXPERIMENT_DIR:/workspace/experiment \
    -v $FIG_DIR:/workspace/fig \
    -v $MODELS_DIR:/workspace/models \
    -v $PLOT_DIR:/workspace/plot \
    -v $RESULTS_DIR:/workspace/results \
    -v $SRC_DIR:/workspace/src \
    -v $SCRIPTS_DIR:/workspace/scripts \
    -v $THIRDPARTY_DIR:/workspace/thirdparty \
    ${IMAGE_NAME}:${IMAGE_TAG} /bin/bash
