#include "../../src/utils/utils.h"
#include <fstream>
#include <iostream>
#include <string>
#include <vector>
#include <unistd.h>

int main(int argc, char* argv[]) {
    std::string X_csv_key_path;
    std::string X_csv_path;
    std::string y_csv_path;

    int opt;
    while ((opt = getopt(argc, argv, "k:x:y:")) != -1) { // Note the colon after 'm'
        switch (opt) {
            case 'k':
                X_csv_key_path = optarg;
                break;
            case 'x':
                X_csv_path = optarg;
                break;
            case 'y':
                y_csv_path = optarg;
                break;
            default:
                std::cerr << "Usage: " << argv[0] << " -k <X_csv_key_path> -x <X_csv_path> -y <y_csv_path>\n";
                return 1;
        }
    }

    if (!X_csv_key_path.empty()) {
        std::cout << "X_csv_key_path: " << X_csv_key_path << std::endl;
        std::string X_bin_key_path = X_csv_key_path.substr(0, X_csv_key_path.size() - 4) + ".bin";
        std::vector<std::string> X_csv_key = load_key(X_csv_key_path);
        save_key_bin(X_bin_key_path, X_csv_key);
        std::vector<std::string> X_bin_key = load_key_bin(X_bin_key_path);
        if (X_csv_key == X_bin_key) {
            std::cout << "OK: " << X_bin_key_path << std::endl;
        } else {
            std::cout << "[ERROR]" << std::endl;
            exit(1);
        }
    }

    if (!X_csv_path.empty()) {
        std::cout << "X_csv_path: " << X_csv_path << std::endl;
        std::string X_bin_path = X_csv_path.substr(0, X_csv_path.size() - 4) + ".bin";
        std::vector<std::vector<float>> X_csv = load_data(X_csv_path);
        save_data_bin(X_bin_path, X_csv);
        std::vector<std::vector<float>> X_bin = load_data_bin(X_bin_path);
        if (X_csv == X_bin) {
            std::cout << "OK: " << X_bin_path << std::endl;
        } else {
            std::cout << "[ERROR]" << std::endl;
            exit(1);
        }
    }

    if (!y_csv_path.empty()) {
        std::cout << "y_csv_path: " << y_csv_path << std::endl;
        std::string y_bin_path = y_csv_path.substr(0, y_csv_path.size() - 4) + ".bin";
        std::vector<std::vector<float>> y_csv = load_data(y_csv_path);
        save_data_bin(y_bin_path, y_csv);
        std::vector<std::vector<float>> y_bin = load_data_bin(y_bin_path);
        if (y_csv == y_bin) {
            std::cout << "OK: " << y_bin_path << std::endl;
        } else {
            std::cout << "[ERROR]" << std::endl;
            exit(1);
        }
    }

    return 0;
}
