#!/bin/bash

set -euo pipefail

./scripts/setup.sh

function run {
    for F in "${Fs[@]}"; do
        F_str=$(echo $F | sed 's/\.//g')
        output_dir="${output_dir_root}/F_${F_str}"
        mkdir -p "$output_dir"
        ./experiment/build/construct_bloom \
            -p "$all_pos_key_path" \
            -k "$X_train_key_path" \
            -y "$y_train_path" \
            -o "$output_dir" \
            -f $F
    done
}

datasets=("url" "ember")
for dataset in "${datasets[@]}"; do
    output_dir_root="models/${dataset}/bloom"
    all_pos_key_path="data/${dataset}/preprocessed/all_pos_key.bin"
    X_train_key_path="data/${dataset}/preprocessed/X_train_key.bin"
    y_train_path="data/${dataset}/preprocessed/y_train.bin"

    # memory <-> fpr trade-off
    Fs=(0.1 0.05 0.02 0.01 0.005 0.002 0.001)
    run
done
