#!/bin/bash

# set -euo pipefail

./scripts/setup.sh

function run {
    for F in "${Fs[@]}"; do
        F_str=$(echo $F | sed 's/\.//g')
        bloom_folder_path="${bloom_folder_dir}/F_${F_str}"
        for pos_query_ratio in "${pos_query_ratios[@]}"; do
            pos_query_ratio_str=$(echo $pos_query_ratio | sed 's/\.//g')
            for query_num in "${query_nums[@]}"; do
                result_folder_path="${result_folder_dir}/F_${F_str}/pr_${pos_query_ratio_str}_qn_${query_num}"
                mkdir -p "$result_folder_path"
                ./experiment/build/test_bloom \
                    -k "$X_test_key_path" \
                    -y "$y_test_path" \
                    -m "$bloom_folder_path" \
                    -o "$result_folder_path" \
                    -p $pos_query_ratio \
                    -q $query_num
                exit_code=$?
                if [ $exit_code -ne 0 ]; then
                    echo "Failed to test BF for directory: $bloom_folder_path"
                    exit $exit_code
                fi
            done
        done
    done
}

datasets=("url" "ember")
for dataset in "${datasets[@]}"; do
    bloom_folder_dir="models/${dataset}/bloom"
    result_folder_dir="results/${dataset}/bloom"
    X_test_key_path="data/${dataset}/preprocessed/X_test_key.bin"
    y_test_path="data/${dataset}/preprocessed/y_test.bin"

    # memory <-> fpr trade-off
    Fs=(0.1 0.05 0.02 0.01 0.005 0.002 0.001)
    pos_query_ratios=(0.0)
    query_nums=(40000)
    run
done
