#!/bin/bash

# set -euo pipefail

./scripts/setup.sh

function run {
    for suffix_trained_xgboost_model_folder_path in "${trained_xgboost_model_folder_paths[@]}"; do
        trained_xgboost_model_folder_path="${xgboost_models_dir}/${suffix_trained_xgboost_model_folder_path}"
        for bit_size_of_Ada_BF in "${bit_size_of_Ada_BFs[@]}"; do
            bit_size_of_Ada_BF_str=$(echo $bit_size_of_Ada_BF | sed 's/\.//g')
            disjointadabf_folder_path="${disjointadabf_dir_root}/${suffix_trained_xgboost_model_folder_path}/bit_size_of_Ada_BF_${bit_size_of_Ada_BF_str}"
            for pos_query_ratio in "${pos_query_ratios[@]}"; do
                pos_query_ratio_str=$(echo $pos_query_ratio | sed 's/\.//g')
                for query_num in "${query_nums[@]}"; do
                    result_folder_path="${result_dir_root}/${suffix_trained_xgboost_model_folder_path}/bit_size_of_Ada_BF_${bit_size_of_Ada_BF_str}/pr_${pos_query_ratio_str}_qn_${query_num}"
                    mkdir -p "$result_folder_path"
                    ./experiment/build/test_disjointadabf \
                        -k "$X_test_key_path" \
                        -x "$X_test_path" \
                        -y "$y_test_path" \
                        -m "$disjointadabf_folder_path" \
                        -o "$result_folder_path" \
                        -p $pos_query_ratio \
                        -q $query_num
                    exit_code=$?
                    if [ $exit_code -ne 0 ]; then
                        echo "Failed to test disjoint AdaBF for directory: $disjointadabf_folder_path"
                        rm -rf "$output_dir"
                    fi
                done
            done
        done
    done
}

datasets=("url" "ember")
for dataset in "${datasets[@]}"; do
    xgboost_models_dir="models/${dataset}/xgboost"
    disjointadabf_dir_root="models/${dataset}/disjointadabf"
    result_dir_root="results/${dataset}/disjointadabf"
    X_test_key_path="data/${dataset}/preprocessed/X_test_key.bin"
    X_test_path="data/${dataset}/preprocessed/X_test.bin"
    y_test_path="data/${dataset}/preprocessed/y_test.bin"

    # memory <-> fpr trade-off
    trained_xgboost_model_folder_paths=(
        "max_depth_1_num_boost_round_1_eta_03"
        "max_depth_1_num_boost_round_10_eta_03"
        "max_depth_1_num_boost_round_100_eta_03"
        "max_depth_2_num_boost_round_1_eta_03"
        "max_depth_2_num_boost_round_10_eta_03"
        "max_depth_2_num_boost_round_100_eta_03"
        "max_depth_4_num_boost_round_1_eta_03"
        "max_depth_4_num_boost_round_10_eta_03"
        "max_depth_4_num_boost_round_100_eta_03"
        "max_depth_6_num_boost_round_1_eta_03"
        "max_depth_6_num_boost_round_10_eta_03"
        "max_depth_6_num_boost_round_100_eta_03"
    )
    if [ "$dataset" == "url" ]; then
        bit_size_of_Ada_BFs=(
            400000 600000 800000 1000000 
            1200000 1400000 1600000 1800000 2000000
        )
    else
        bit_size_of_Ada_BFs=(
            800000 1200000 1600000 2000000
            2400000 2800000 3200000 3600000 4000000
        )
    fi
    pos_query_ratios=(0.0)
    query_nums=(40000)
    run

    # memory <-> reject time trade-off
    trained_xgboost_model_folder_paths=(
        "max_depth_4_num_boost_round_1_eta_03"
        "max_depth_4_num_boost_round_2_eta_03"
        "max_depth_4_num_boost_round_3_eta_03"
        "max_depth_4_num_boost_round_4_eta_03"
        "max_depth_4_num_boost_round_5_eta_03"
        "max_depth_4_num_boost_round_6_eta_03"
        "max_depth_4_num_boost_round_7_eta_03"
        "max_depth_4_num_boost_round_8_eta_03"
        "max_depth_4_num_boost_round_9_eta_03"
        "max_depth_4_num_boost_round_10_eta_03"
        "max_depth_4_num_boost_round_20_eta_03"
        "max_depth_4_num_boost_round_30_eta_03"
        "max_depth_4_num_boost_round_40_eta_03"
        "max_depth_4_num_boost_round_50_eta_03"
        "max_depth_4_num_boost_round_60_eta_03"
        "max_depth_4_num_boost_round_70_eta_03"
        "max_depth_4_num_boost_round_80_eta_03"
        "max_depth_4_num_boost_round_90_eta_03"
        "max_depth_4_num_boost_round_100_eta_03"
    )
    if [ "$dataset" == "url" ]; then
        bit_size_of_Ada_BFs=(
            400000 600000 800000 1000000 
            1200000 1400000 1600000 1800000 2000000
        )
    else
        bit_size_of_Ada_BFs=(
            800000 1200000 1600000 2000000
            2400000 2800000 3200000 3600000 4000000
        )
    fi
    pos_query_ratios=(0.0)
    query_nums=(40000)
    run

    trained_xgboost_model_folder_paths=(
        "max_depth_4_num_boost_round_1_eta_03"
        "max_depth_4_num_boost_round_2_eta_03"
        "max_depth_4_num_boost_round_3_eta_03"
        "max_depth_4_num_boost_round_4_eta_03"
        "max_depth_4_num_boost_round_5_eta_03"
        "max_depth_4_num_boost_round_6_eta_03"
        "max_depth_4_num_boost_round_7_eta_03"
        "max_depth_4_num_boost_round_8_eta_03"
        "max_depth_4_num_boost_round_9_eta_03"
        "max_depth_4_num_boost_round_10_eta_03"
        "max_depth_4_num_boost_round_20_eta_03"
        "max_depth_4_num_boost_round_30_eta_03"
        "max_depth_4_num_boost_round_40_eta_03"
        "max_depth_4_num_boost_round_50_eta_03"
        "max_depth_4_num_boost_round_60_eta_03"
        "max_depth_4_num_boost_round_70_eta_03"
        "max_depth_4_num_boost_round_80_eta_03"
        "max_depth_4_num_boost_round_90_eta_03"
    )
    if [ "$dataset" == "url" ]; then
        bit_size_of_Ada_BFs=(
            1400000 1500000 
            1600000 1700000 
            1800000 1900000 
            2000000
        )
    else
        bit_size_of_Ada_BFs=(
            3500000 3600000
            3700000 3800000
            3900000 4000000
        )
    fi
    pos_query_ratios=(0.0)
    query_nums=(40000)
    run
done
