#!/bin/bash

set -euo pipefail

# Define the dataset path
EMBER_DATASET_FOLDER_PATH="data/ember/ember2018/"
DATASET_PATH="data/ember/ember_dataset_2018_2.tar.bz2"
DOWNLOAD_PATH="data/ember/"

# Check if the dataset already exists
if [ -d $EMBER_DATASET_FOLDER_PATH ]; then
    echo "The dataset already exists. Skipping download."
    exit 0
fi

mkdir -p data/ember

echo "Downloading ember dataset..."
wget https://ember.elastic.co/ember_dataset_2018_2.tar.bz2 -O $DATASET_PATH

echo "Extracting the dataset..."
tar -xvjf $DATASET_PATH -C $DOWNLOAD_PATH

echo "Cleaning up..."
rm $DATASET_PATH

echo "Done! The dataset has been extracted to data/ember/"
