#!/bin/bash

set -euo pipefail

./scripts/setup.sh

function run {
    for bits_per_key in "${bits_per_keys[@]}"; do
        bits_per_key_str=$(echo $bits_per_key | sed 's/\.//g')
        for pos_query_ratio in "${pos_query_ratios[@]}"; do
            pos_query_ratio_str=$(echo $pos_query_ratio | sed 's/\.//g')
            for query_num in "${query_nums[@]}"; do
                model_folder_path="${model_folder_dir}/bpk_${bits_per_key_str}"
                result_folder_path="${result_folder_dir}/bpk_${bits_per_key_str}/pr_${pos_query_ratio_str}_qn_${query_num}"
                mkdir -p "$model_folder_path"
                mkdir -p "$result_folder_path"
                ./experiment/build/construct_and_test_habf \
                    -p "$all_pos_key_path" \
                    -k "$X_train_key_path" \
                    -y "$y_train_path" \
                    -v "$X_val_key_path" \
                    -w "$y_val_path" \
                    -b $bits_per_key \
                    -t "$X_test_key_path" \
                    -u "$y_test_path" \
                    -m "$model_folder_path" \
                    -o "$result_folder_path" \
                    -r $pos_query_ratio \
                    -q $query_num
            done
        done
    done
}

datasets=("url" "ember")
for dataset in "${datasets[@]}"; do
    all_pos_key_path="data/${dataset}/preprocessed/all_pos_key.bin"
    X_train_key_path="data/${dataset}/preprocessed/X_train_key.bin"
    y_train_path="data/${dataset}/preprocessed/y_train.bin"
    X_val_key_path="data/${dataset}/preprocessed/X_val_key.bin"
    y_val_path="data/${dataset}/preprocessed/y_val.bin"
    bits_per_keys=(1 2 3 4 5 6 7 8 9 10 11 12 13 14 15)
    X_test_key_path="data/${dataset}/preprocessed/X_test_key.bin"
    y_test_path="data/${dataset}/preprocessed/y_test.bin"
    model_folder_dir="models/${dataset}/habf"
    result_folder_dir="results/${dataset}/habf"
    pos_query_ratios=(0.0)
    query_nums=(40000)
    run
done
