#!/bin/bash

# set -euo pipefail

./scripts/setup.sh

function run {
    for suffix_trained_xgboost_model_folder_path in "${trained_xgboost_model_folder_paths[@]}"; do
        trained_xgboost_model_folder_path="${xgboost_models_dir}/${suffix_trained_xgboost_model_folder_path}"
        for F in "${Fs[@]}"; do
            F_str=$(echo $F | sed 's/\.//g')
            output_dir="${output_dir_root}/${suffix_trained_xgboost_model_folder_path}/F_${F_str}"
            mkdir -p "$output_dir"
            ./experiment/build/construct_plbf \
                -p "$all_pos_key_path" \
                -q "$all_pos_X_path" \
                -k "$X_val_key_path" \
                -x "$X_val_path" \
                -y "$y_val_path" \
                -t "$trained_xgboost_model_folder_path" \
                -o "$output_dir" \
                -f $F
        done
    done
}

datasets=("url" "ember")
for dataset in "${datasets[@]}"; do
    xgboost_models_dir="models/${dataset}/xgboost"
    output_dir_root="models/${dataset}/plbf"
    all_pos_key_path="data/${dataset}/preprocessed/all_pos_key.bin"
    all_pos_X_path="data/${dataset}/preprocessed/all_pos_X.bin"
    X_val_key_path="data/${dataset}/preprocessed/X_val_key.bin"
    X_val_path="data/${dataset}/preprocessed/X_val.bin"
    y_val_path="data/${dataset}/preprocessed/y_val.bin"

    # memory <-> fpr trade-off
    trained_xgboost_model_folder_paths=(
        "max_depth_1_num_boost_round_1_eta_03"
        "max_depth_1_num_boost_round_10_eta_03"
        "max_depth_1_num_boost_round_100_eta_03"
        "max_depth_2_num_boost_round_1_eta_03"
        "max_depth_2_num_boost_round_10_eta_03"
        "max_depth_2_num_boost_round_100_eta_03"
        "max_depth_4_num_boost_round_1_eta_03"
        "max_depth_4_num_boost_round_10_eta_03"
        "max_depth_4_num_boost_round_100_eta_03"
        "max_depth_6_num_boost_round_1_eta_03"
        "max_depth_6_num_boost_round_10_eta_03"
        "max_depth_6_num_boost_round_100_eta_03"
    )
    Fs=(0.1 0.05 0.02 0.01 0.005 0.002 0.001)
    run

    # memory <-> reject time trade-off
    trained_xgboost_model_folder_paths=(
        "max_depth_1_num_boost_round_1_eta_03"
        "max_depth_1_num_boost_round_2_eta_03"
        "max_depth_1_num_boost_round_3_eta_03"
        "max_depth_1_num_boost_round_4_eta_03"
        "max_depth_1_num_boost_round_5_eta_03"
        "max_depth_1_num_boost_round_6_eta_03"
        "max_depth_1_num_boost_round_7_eta_03"
        "max_depth_1_num_boost_round_8_eta_03"
        "max_depth_1_num_boost_round_9_eta_03"
        "max_depth_1_num_boost_round_10_eta_03"
        "max_depth_1_num_boost_round_20_eta_03"
        "max_depth_1_num_boost_round_30_eta_03"
        "max_depth_1_num_boost_round_40_eta_03"
        "max_depth_1_num_boost_round_50_eta_03"
        "max_depth_1_num_boost_round_60_eta_03"
        "max_depth_1_num_boost_round_70_eta_03"
        "max_depth_1_num_boost_round_80_eta_03"
        "max_depth_1_num_boost_round_90_eta_03"
        "max_depth_1_num_boost_round_100_eta_03"
        "max_depth_2_num_boost_round_1_eta_03"
        "max_depth_2_num_boost_round_2_eta_03"
        "max_depth_2_num_boost_round_3_eta_03"
        "max_depth_2_num_boost_round_4_eta_03"
        "max_depth_2_num_boost_round_5_eta_03"
        "max_depth_2_num_boost_round_6_eta_03"
        "max_depth_2_num_boost_round_7_eta_03"
        "max_depth_2_num_boost_round_8_eta_03"
        "max_depth_2_num_boost_round_9_eta_03"
        "max_depth_2_num_boost_round_10_eta_03"
        "max_depth_2_num_boost_round_20_eta_03"
        "max_depth_2_num_boost_round_30_eta_03"
        "max_depth_2_num_boost_round_40_eta_03"
        "max_depth_2_num_boost_round_50_eta_03"
        "max_depth_2_num_boost_round_60_eta_03"
        "max_depth_2_num_boost_round_70_eta_03"
        "max_depth_2_num_boost_round_80_eta_03"
        "max_depth_2_num_boost_round_90_eta_03"
        "max_depth_2_num_boost_round_100_eta_03"
        "max_depth_4_num_boost_round_1_eta_03"
        "max_depth_4_num_boost_round_2_eta_03"
        "max_depth_4_num_boost_round_3_eta_03"
        "max_depth_4_num_boost_round_4_eta_03"
        "max_depth_4_num_boost_round_5_eta_03"
        "max_depth_4_num_boost_round_6_eta_03"
        "max_depth_4_num_boost_round_7_eta_03"
        "max_depth_4_num_boost_round_8_eta_03"
        "max_depth_4_num_boost_round_9_eta_03"
        "max_depth_4_num_boost_round_10_eta_03"
        "max_depth_4_num_boost_round_20_eta_03"
        "max_depth_4_num_boost_round_30_eta_03"
        "max_depth_4_num_boost_round_40_eta_03"
        "max_depth_4_num_boost_round_50_eta_03"
        "max_depth_4_num_boost_round_60_eta_03"
        "max_depth_4_num_boost_round_70_eta_03"
        "max_depth_4_num_boost_round_80_eta_03"
        "max_depth_4_num_boost_round_90_eta_03"
        "max_depth_4_num_boost_round_100_eta_03"
        "max_depth_6_num_boost_round_1_eta_03"
        "max_depth_6_num_boost_round_2_eta_03"
        "max_depth_6_num_boost_round_3_eta_03"
        "max_depth_6_num_boost_round_4_eta_03"
        "max_depth_6_num_boost_round_5_eta_03"
        "max_depth_6_num_boost_round_6_eta_03"
        "max_depth_6_num_boost_round_7_eta_03"
        "max_depth_6_num_boost_round_8_eta_03"
        "max_depth_6_num_boost_round_9_eta_03"
        "max_depth_6_num_boost_round_10_eta_03"
        "max_depth_6_num_boost_round_20_eta_03"
        "max_depth_6_num_boost_round_30_eta_03"
        "max_depth_6_num_boost_round_40_eta_03"
        "max_depth_6_num_boost_round_50_eta_03"
        "max_depth_6_num_boost_round_60_eta_03"
        "max_depth_6_num_boost_round_70_eta_03"
        "max_depth_6_num_boost_round_80_eta_03"
        "max_depth_6_num_boost_round_90_eta_03"
        "max_depth_6_num_boost_round_100_eta_03"
    )
    Fs=(0.1 0.01 0.001)
    run
done
