#!/bin/bash

set -euo pipefail

# rm -rf models/*
# rm -rf results/*
# rm -rf fig/*

# Download the dataset
./scripts/download_dataset/url_download.sh
./scripts/download_dataset/ember_download.sh

# Preprocess the dataset
./scripts/preprocess/url_preprocess.sh
./scripts/preprocess/ember_preprocess.sh

# Train XGBoost
./scripts/xgboost/train_xgboost.sh

# Construct and Test BF
./scripts/bloom/construct_bloom.sh
./scripts/bloom/test_bloom.sh

# Construct and Test CLBF
./scripts/clbf/construct_clbf.sh
./scripts/clbf/test_clbf.sh

# Construct and Test PLBF
./scripts/plbf/construct_plbf.sh
./scripts/plbf/test_plbf.sh

# Construct and Test SandwichedLBF
./scripts/sandwichedlbf/construct_sandwichedlbf.sh
./scripts/sandwichedlbf/test_sandwichedlbf.sh

# Construct and Test PHBF
./scripts/phbf/construct_and_test_phbf.sh

# Construct and Test DisjointAdaBF
./scripts/disjointadabf/construct_disjointadabf.sh
./scripts/disjointadabf/test_disjointadabf.sh

# Construct and Test HABF
./scripts/habf/construct_and_test_habf.sh

# Plot the results
./scripts/plot/plot.sh
